% ALPHA ENGINE DEFINITION
% Generated 28-Feb-2023 11:14:48

% SUGGESTED CITATION:
% GT Power Baseline 2020 Ford 7.3L Engine from Argonne Report Tier 3 Fuel - ALPHA Map Package. Version 2023-02. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
engine = class_REVS_engine();
engine.name =  'GT Power Baseline 2020 Ford 7.3L Engine from Argonne Report Tier 3 Fuel'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  7.293; 
engine.num_cylinders =  8; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  10.5; 
engine.bore_mm =  107.2; 
engine.stroke_mm =  101; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	     0.0000000000000000	;     52.359877559829883	;     104.71975511965977	;     157.89633786087768	;     213.97676129357288	;     259.16778213322823	;     302.72539261010741	;     416.51964994299368	;     451.91020839655323	;     494.92334871760062	;     560.25976438055966	;     588.27275259958765	;     616.28574081861564		]; 
engine.full_throttle_torque_Nm = [	     0.0000000000000000	;     360.06158081791830	;     468.50919825431498	;     555.10454272071195	;     584.91834195043396	;     599.11538881530601	;     600.53509295946594	;     653.06416798647399	;     633.18830183332602	;     628.92918804502801	;     580.65922680631797	;     497.70790869112977	;     0.0000000000000000		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	     0.0000000000000000	;     60.650191506802955	;     104.71975511965977	;     340.33920413889422	;     471.23889803846896	;     733.03828583761833		]; 
engine.closed_throttle_torque_Nm = [	    -58.167200000000008	;    -59.342418368830536	;    -73.094838994814410	;    -104.76327548228690	;    -115.17343884571348	;    -123.76102372227928		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	     0.0000000000000000	;     30.325095753401477	;     60.650191506802955	;     83.775804095727807	;     104.71975511965977	;     130.89969389957471	;     157.07963267948966	;     183.25957145940458	;     209.43951023931953	;     235.61944901923448	;     261.79938779914943	;     287.97932657906438	;     314.15926535897933	;     340.33920413889422	;     366.51914291880917	;     392.69908169872411	;     415.21382904945096	;     443.22636354395996	;     471.23889803846896	;     497.41883681838391	;     523.59877559829886	;     569.94225820845725	;     616.28574081861564		]; 
engine.fuel_map_torque_Nm = [	    -166.10139000000004	;    -53.781170024028533	;     58.539049951942971	;     87.476373559214665	;     116.41369716648636	;     145.29274199485508	;     174.17178682322378	;     203.40355987891314	;     232.63533293460253	;     260.69239545085509	;     288.74945796710762	;     319.03076641480573	;     349.31207486250383	;     378.55062583152096	;     407.78917680053814	;     437.50503338313047	;     467.22088996572279	;     495.26759615132818	;     523.31430233693357	;     604.51583936136558	;     685.71737638579771		]; 
engine.fuel_map_gps = [
 -0.099846698760828329	  -0.35633784259234147	  -0.47111770650844298	  -0.52371747344677944	  -0.57125707657331082	  -0.63046019360519900	  -0.68921453379783570	  -0.74736456949549479	  -0.80485826639957303	  -0.86174319434220492	  -0.91814498902862274	  -0.97424221737225503	   -1.0302362667565486	   -1.0863146360046390	   -1.1426335251307815	   -1.1993080253132475	   -1.2483665262553463	   -1.3098663090449811	   -1.3719537391464975	   -1.4304581674112327	   -1.4893238914773235	   -1.5943786810111689	   -1.6999086985352476	;
 -0.014934570767375061	-0.0097081250912450911	  0.032167476286703384	  0.067281521127778937	   0.10233508728638892	   0.15182552337953326	   0.20900808978494595	   0.27406719407257507	   0.34801276477072518	   0.43168061602996938	   0.52573512029729308	   0.63061082472406271	   0.74651735365399641	   0.87301130387438020	    1.0091121353316923	    1.1534653818034200	    1.2826083498948573	    1.4489101631815102	    1.6212972742221914	    1.7871186666410086	    1.9563876707223800	    2.2640323714543755	    2.5766748328756752	;
   0.20504858032064538	   0.37249645618171345	   0.52674243541614563	   0.61905759662267934	   0.74175471222437672	   0.94778969237475219	    1.1782534508180806	    1.3638526976585814	    1.5544568190129027	    1.7614286834093393	    1.9852758700313768	    2.2259327857934252	    2.5017920391120518	    2.8041261377842739	    3.1316255402762576	    3.4847683786390728	    3.7956627049802107	    4.1763317461311855	    4.5767584956245804	    4.9875515428232466	    5.4140714607361540	    6.1531883337820830	    6.8864712631800664	;
   0.19498380318264602	   0.40034580398616215	   0.61016948766848511	   0.77907434188522451	   0.94731124557729274	    1.1800032161893670	    1.4241669673595754	    1.6588286963965817	    1.8881761659109535	    2.1266568606946699	    2.3856249104250735	    2.6724203655588248	    2.9871821406128962	    3.3240937574040528	    3.6816825063485412	    4.0635653601372885	    4.4113911000936010	    4.8666758904929939	    5.3476799021645247	    5.8183160623470442	    6.2978591260716223	    7.1394851255132528	    7.9679993063475161	;
   0.19122985261254080	   0.44075727025336087	   0.69892549778100166	   0.91516208348400296	    1.1261442299780124	    1.4005206001181842	    1.6901319673589541	    1.9571458920102252	    2.2185728950308747	    2.4893331926014897	    2.7861235298946365	    3.1212571391166311	    3.4869431284490862	    3.8639233360922880	    4.2521980791984744	    4.6666329384767646	    5.0586293194188148	    5.5779623190844516	    6.1224319265338210	    6.6565346478215126	    7.1965847522512707	    8.1267432529830952	    9.0450941763257973	;
   0.20525052939932101	   0.50772175979653089	   0.81420503454983539	    1.0604282501121616	    1.2962059104263848	    1.6061027724153383	    1.9216033082788426	    2.2286538736745261	    2.5343554421978300	    2.8543279724442687	    3.2029441174527888	    3.5855223145152957	    3.9959841479137568	    4.4234376092359780	    4.8669048610838281	    5.3355515794999153	    5.7644511957189231	    6.3306546946058706	    6.9288747640244255	    7.5076359251389650	    8.0925982153707778	    9.1121417949870445	    10.120027489027105	;
   0.23404312025884791	   0.59160532260061838	   0.94033265682689482	    1.1980155021707979	    1.4588391624120698	    1.8069605898687877	    2.1649713558886052	    2.5060535780775082	    2.8536988891631707	    3.2221557433461245	    3.6239515671348661	    4.0596832719019940	    4.5234784319264456	    5.0079209981889434	    5.5041870205416901	    6.0210567391173697	    6.4929173057176559	    7.1035416777990950	    7.7459136940948810	    8.3681842211417639	    9.0021871665514226	    10.102518037206263	    11.202979999980535	;
   0.26844250680653758	   0.66174598431906562	    1.0529606974458035	    1.3558003193544628	    1.6423861027601681	    2.0180436962231787	    2.4061273932190681	    2.7994129545827731	    3.2021943735183065	    3.6244600480290980	    4.0759428653020642	    4.5577293267478014	    5.0670977707892018	    5.5988521275662535	    6.1479815304536949	    6.7171942926009685	    7.2268337125560453	    7.8869269337982235	    8.5757691100730504	    9.2398019539988425	    9.9142482002436143	    11.115916449996718	    12.319233260315755	;
   0.31348854461177017	   0.73950327903277169	    1.1697643661425461	    1.5007915405082404	    1.8233033705546577	    2.2402152594482603	    2.6705435421891730	    3.1151430825424558	    3.5682516525756145	    4.0364188976737916	    4.5398735437969524	    5.0656567186045223	    5.6187628988184137	    6.1992695879828679	    6.7966463489684648	    7.4112751937946619	    7.9665315089325164	    8.6812447644939894	    9.4198850465329791	    10.132455910967055	    10.855481015461677	    12.157934352388040	    13.467910459716993	;
   0.37481320970204957	   0.83043616790502672	    1.2883995013726974	    1.6502457972733326	    2.0016269132750741	    2.4612433824712556	    2.9386239030744492	    3.4311703855612317	    3.9291548584799325	    4.4467359693514315	    4.9941111688917426	    5.5616872432397031	    6.1535197628302187	    6.7725272840376851	    7.4183721281804074	    8.0930043464083230	    8.6949026680718493	    9.4680402835530852	    10.264677611688594	    11.026419732617141	    11.800126798958001	    13.197862904545785	    14.610979747806383	;
   0.45481166650737176	   0.94190367756218074	    1.4332058241930388	    1.8190023364471977	    2.1954380305467751	    2.6878553461952404	    3.2058449836660703	    3.7439773635380513	    4.2806784429929934	    4.8391465423513269	    5.4394989600259027	    6.0537665647917409	    6.6906746120897020	    7.3543973198666137	    8.0493243300403279	    8.7827737924124172	    9.4383156284007903	    10.276172844545712	    11.136671474096252	    11.955053770688185	    12.784598346699008	    14.282376075666450	    15.800734497179244	;
   0.56042247827107594	    1.0631221258385488	    1.5769978343780895	    1.9951456438971478	    2.3955597262870572	    2.9255298275296426	    3.4804015531512977	    4.0555159189569014	    4.6472007904025201	    5.2581909458231735	    5.8990336035918087	    6.5695513329016135	    7.2698739436958011	    7.9987507696834417	    8.7576091166411416	    9.5474061247112036	    10.252672375929052	    11.164838211792702	    12.106298918404088	    12.995244561735626	    13.892100549014456	    15.507538157637454	    17.143459822468177	;
   0.67539958902424824	    1.2124081999387666	    1.7392802696022671	    2.1812218169666160	    2.6037667418981236	    3.1691294115137367	    3.7553122098581406	    4.3685740713731702	    5.0091961921969874	    5.6647202053987629	    6.3593452042603422	    7.0882873786728720	    7.8628228951069268	    8.6672156666313089	    9.4973536201387816	    10.330660755566740	    11.074914110593745	    12.066220585498652	    13.110715622642845	    14.075054333259336	    15.047296454133434	    16.792232791987189	    18.546671651412112	;
   0.76352980501886447	    1.3711137587968378	    1.9721591710978466	    2.4303250984971263	    2.8594700370146358	    3.4279512401055623	    4.0319989093287383	    4.6782229291889417	    5.3548751940166506	    6.0686100576595150	    6.8254849694113666	    7.6138779818269740	    8.4564957822102542	    9.3422724790203553	    10.236951464043504	    11.115596160116461	    11.900566067049802	    12.957308813757404	    14.083151263850027	    15.150583349680449	    16.216019174329933	    18.087231569954213	    19.948380084436589	;
   0.81783742550198180	    1.5004477360818327	    2.1801672913837544	    2.6959956359357347	    3.1634909463116432	    3.7506382645182090	    4.3485457874706110	    5.0201682008023578	    5.7191690750841078	    6.4680379972903390	    7.2814732010335002	    8.1197951169132239	    9.0412466177699198	    10.056147151207371	    11.094372596793345	    11.993073485696064	    12.796291091841566	    13.952189855651151	    15.172509440921012	    16.316537560290605	    17.451148880419598	    19.427549674275980	    21.383289503065622	;
   0.83779927208793181	    1.6066179125296460	    2.3764271542055870	    2.9650564161747601	    3.4984105915875485	    4.1601159624937605	    4.8011575498864643	    5.4413616720450637	    6.1336503046366291	    6.9109903536712309	    7.7575888455077981	    8.6657092718314921	    9.6714816604973954	    10.794249406923887	    11.952671951630103	    13.064781425404608	    14.008930482477362	    15.208421915061601	    16.443117557448126	    17.610415324463837	    18.778100337958673	    20.830338246420769	    22.866869839137216	;
   0.82705081351117260	    1.6894789021192731	    2.5530151707178081	    3.2151660396359030	    3.8222463762899093	    4.6077664655043442	    5.3172066197986165	    5.9021859067400344	    6.5857896714612458	    7.4074725442231344	    8.3044771885059685	    9.2644857659040518	    10.350637175690308	    11.636894639845394	    13.012858137916149	    14.265766367301477	    15.300130138193786	    16.558909593789569	    17.811875767906642	    18.988262116632345	    20.170076283858709	    22.271740024604828	    24.373834897421421	;
   0.79241900580777180	    1.7478788792354523	    2.7054153178922831	    3.4387615511502676	    4.1033497668045396	    4.9215626002504278	    5.6690781695444636	    6.3618879337670196	    7.0876014052442873	    7.9086362722574073	    8.8481236312172928	    9.9318566372851631	    11.179436023522381	    12.590239077328446	    14.050274939274532	    15.411995051311932	    16.518400543720734	    17.835843119069335	    19.121401051559431	    20.317724254869457	    21.518093301296812	    23.662036354779627	    25.819770611567115	;
   0.73562746609749974	    1.7826778291614154	    2.8271823746777875	    3.6157858049371314	    4.3195101689159383	    5.1769171950913613	    6.0036134418335658	    6.8056544061571245	    7.6217951581638488	    8.4391392465322745	    9.4173140132627289	    10.633532671099578	    12.032296705653897	    13.558130797558924	    15.144593243809629	    16.560265667071835	    17.707189511452690	    19.076463510269090	    20.408715865462892	    21.641705628834373	    22.874492888271256	    25.072387063110455	    27.290325622592967	;
   0.30428653925475496	    1.5515278076462213	    2.7953017051544706	    3.7400388565037734	    4.5938141532311869	    5.6615320689061921	    6.7392899650068943	    7.8413359920668730	    8.9875446833931676	    10.204176557060682	    11.523172474311751	    12.952343897039341	    14.463701552687867	    16.026491190593848	    17.610826428406575	    19.190631911551247	    20.533760310057929	    22.177722937023322	    23.787712862766160	    25.267136892820837	    26.728851918830557	    29.276320474753408	    31.802910927602930	;
  -0.18075111906533062	    1.2686496122714794	    2.7194201196697718	    3.8279582147925204	    4.9113808830168448	    6.3168829431891549	    7.7450178438629695	    9.2003185387132618	    10.685877405295706	    12.203062187559869	    13.751466480202859	    15.329436425175491	    16.934665037834897	    18.564534434702203	    20.216215708624052	    21.886508232590558	    23.333870291182336	    25.145595399884915	    26.965326148526302	    28.669066901550845	    30.373296716525431	    33.387785057956535	    36.397954205833386	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('LMDV_TIER_3_REG');

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	     52.359877559829883	    52.359877559829883		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
